<?php
require_once __DIR__ . '/../config/db.php';

try {
    // Add 'credit_sale' to the source_type ENUM in product_serial_numbers table
    $pdo->exec("ALTER TABLE product_serial_numbers MODIFY COLUMN source_type ENUM('manual_adjustment', 'supplier_receipt', 'refund', 'credit_sale') NOT NULL");
    echo "Successfully added 'credit_sale' to source_type ENUM in product_serial_numbers table.\n";
    
    // Verify the change
    $stmt = $pdo->query("DESCRIBE product_serial_numbers");
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        if ($row['Field'] === 'source_type') {
            echo "Current source_type ENUM values: " . $row['Type'] . "\n";
            break;
        }
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
} 